package easik.ui.menu.popup;

import java.awt.Point;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;

/**
 * Action for the new entity option in the popup menu.
 * 
 * @author Rob Fletcher 2005
 */
public class NewEntityAction extends AbstractAction {
	/**
	 * The point at which to place the new entity
	 */
	Point _newPoint;

	/**
	 * Prepare the menu option, as well as pass a reference to the last
	 * clicked point, which is used when positioning the new entity.
	 * 
	 * @param inPoint The sketch's last-rightclicked-position
	 */
	public NewEntityAction(Point inPoint) {
		super("Add entity...");
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Add a new entity to the sketch");

		_newPoint = inPoint;
	}

	/**
	 * Create the new entity and set up its name
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		String newName =
			Easik.getInstance().getFrame().getSketch().getNewName();

		newName =
			(String) JOptionPane.showInputDialog(
				Easik.getInstance().getFrame(),
				"Name for new entity:",
				"Get name",
				JOptionPane.QUESTION_MESSAGE,
				null,
				null,
				newName);
		newName = newName.trim();

		if (newName == null) {
			return;
		}
		
		while(newName.equals("") || newName.equalsIgnoreCase("fail") ||Easik
				.getInstance()
				.getFrame()
				.getSketch()
				.isNameUsed(newName)){
			JOptionPane.showMessageDialog(
					Easik.getInstance().getFrame(),
					"Error while naming entity.\n"+
					"Please ensure that entity name is:\n"+
					"1) Not blank\n"+
					"2) Not the restricted name, 'Fail'\n"+
					"3) Not already in use",
					"Error",
					JOptionPane.ERROR_MESSAGE);
				newName =
					(String) JOptionPane.showInputDialog(
						Easik.getInstance().getFrame(),
						"Name for new entity:",
						"Get name",
						JOptionPane.QUESTION_MESSAGE,
						null,
						null,
						newName);
				if (newName == null) {
					return;
				}
				newName = newName.trim();
		}

		Easik.getInstance().getFrame().getSketch().addNewEntity(
			newName,
			_newPoint.getX(),
			_newPoint.getY());
		Easik.getInstance().getFrame().getSketch().setDirty(true);
	}

}
